package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait AmiSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.AmiSortBy
}
object AmiSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.AmiSortBy
  ): zio.aws.inspector2.model.AmiSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.AmiSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.AmiSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.AmiSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.AmiSortBy.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.inspector2.model.AmiSortBy.AFFECTED_INSTANCES =>
      val r = AFFECTED_INSTANCES
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.AmiSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AmiSortBy =
      software.amazon.awssdk.services.inspector2.model.AmiSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.AmiSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AmiSortBy =
      software.amazon.awssdk.services.inspector2.model.AmiSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.AmiSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AmiSortBy =
      software.amazon.awssdk.services.inspector2.model.AmiSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.AmiSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AmiSortBy =
      software.amazon.awssdk.services.inspector2.model.AmiSortBy.ALL
  }
  case object AFFECTED_INSTANCES extends zio.aws.inspector2.model.AmiSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AmiSortBy =
      software.amazon.awssdk.services.inspector2.model.AmiSortBy.AFFECTED_INSTANCES
  }
}
