package zio.aws.inspector2
import zio.aws.inspector2.model.ListUsageTotalsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.inspector2.model.{
  UpdateFilterRequest,
  GetDelegatedAdminAccountRequest,
  ListDelegatedAdminAccountsRequest,
  ListAccountPermissionsRequest,
  ListMembersRequest,
  ListTagsForResourceRequest,
  BatchGetAccountStatusRequest,
  CreateFindingsReportRequest,
  DisableDelegatedAdminAccountRequest,
  CreateFilterRequest,
  DisableRequest,
  GetMemberRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListFiltersRequest,
  AssociateMemberRequest,
  CancelFindingsReportRequest,
  UntagResourceRequest,
  DeleteFilterRequest,
  EnableRequest,
  GetFindingsReportStatusRequest,
  ListUsageTotalsRequest,
  BatchGetFreeTrialInfoRequest,
  DisassociateMemberRequest,
  DescribeOrganizationConfigurationRequest,
  ListCoverageRequest,
  TagResourceRequest,
  ListCoverageStatisticsRequest,
  EnableDelegatedAdminAccountRequest,
  ListFindingAggregationsRequest
}
import zio.stream.ZStream
object Inspector2Mock extends Mock[Inspector2] {
  object Enable
      extends Effect[
        EnableRequest,
        AwsError,
        zio.aws.inspector2.model.EnableResponse.ReadOnly
      ]
  object ListFindings
      extends Stream[
        ListFindingsRequest,
        AwsError,
        zio.aws.inspector2.model.Finding.ReadOnly
      ]
  object ListFindingsPaginated
      extends Effect[
        ListFindingsRequest,
        AwsError,
        zio.aws.inspector2.model.ListFindingsResponse.ReadOnly
      ]
  object EnableDelegatedAdminAccount
      extends Effect[
        EnableDelegatedAdminAccountRequest,
        AwsError,
        zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly
      ]
  object ListCoverage
      extends Stream[
        ListCoverageRequest,
        AwsError,
        zio.aws.inspector2.model.CoveredResource.ReadOnly
      ]
  object ListCoveragePaginated
      extends Effect[
        ListCoverageRequest,
        AwsError,
        zio.aws.inspector2.model.ListCoverageResponse.ReadOnly
      ]
  object Disable
      extends Effect[
        DisableRequest,
        AwsError,
        zio.aws.inspector2.model.DisableResponse.ReadOnly
      ]
  object UpdateOrganizationConfiguration
      extends Effect[
        UpdateOrganizationConfigurationRequest,
        AwsError,
        zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.ReadOnly
      ]
  object DeleteFilter
      extends Effect[
        DeleteFilterRequest,
        AwsError,
        zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly
      ]
  object DisassociateMember
      extends Effect[
        DisassociateMemberRequest,
        AwsError,
        zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly
      ]
  object DisableDelegatedAdminAccount
      extends Effect[
        DisableDelegatedAdminAccountRequest,
        AwsError,
        zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly
      ]
  object CreateFilter
      extends Effect[
        CreateFilterRequest,
        AwsError,
        zio.aws.inspector2.model.CreateFilterResponse.ReadOnly
      ]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.inspector2.model.Member.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.inspector2.model.ListMembersResponse.ReadOnly
      ]
  object ListFindingAggregations
      extends Stream[
        ListFindingAggregationsRequest,
        AwsError,
        zio.aws.inspector2.model.AggregationResponse.ReadOnly
      ]
  object ListFindingAggregationsPaginated
      extends Effect[
        ListFindingAggregationsRequest,
        AwsError,
        zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly
      ]
  object CancelFindingsReport
      extends Effect[
        CancelFindingsReportRequest,
        AwsError,
        zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.inspector2.model.UntagResourceResponse.ReadOnly
      ]
  object ListDelegatedAdminAccounts
      extends Stream[
        ListDelegatedAdminAccountsRequest,
        AwsError,
        zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
      ]
  object ListDelegatedAdminAccountsPaginated
      extends Effect[
        ListDelegatedAdminAccountsRequest,
        AwsError,
        zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly
      ]
  object GetMember
      extends Effect[
        GetMemberRequest,
        AwsError,
        zio.aws.inspector2.model.GetMemberResponse.ReadOnly
      ]
  object ListFilters
      extends Stream[
        ListFiltersRequest,
        AwsError,
        zio.aws.inspector2.model.Filter.ReadOnly
      ]
  object ListFiltersPaginated
      extends Effect[
        ListFiltersRequest,
        AwsError,
        zio.aws.inspector2.model.ListFiltersResponse.ReadOnly
      ]
  object DescribeOrganizationConfiguration
      extends Effect[
        DescribeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object AssociateMember
      extends Effect[
        AssociateMemberRequest,
        AwsError,
        zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.inspector2.model.TagResourceResponse.ReadOnly
      ]
  object CreateFindingsReport
      extends Effect[
        CreateFindingsReportRequest,
        AwsError,
        zio.aws.inspector2.model.CreateFindingsReportResponse.ReadOnly
      ]
  object BatchGetAccountStatus
      extends Effect[
        BatchGetAccountStatusRequest,
        AwsError,
        zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly
      ]
  object GetDelegatedAdminAccount
      extends Effect[
        GetDelegatedAdminAccountRequest,
        AwsError,
        zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly
      ]
  object BatchGetFreeTrialInfo
      extends Effect[
        BatchGetFreeTrialInfoRequest,
        AwsError,
        zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly
      ]
  object UpdateFilter
      extends Effect[
        UpdateFilterRequest,
        AwsError,
        zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly
      ]
  object GetFindingsReportStatus
      extends Effect[
        GetFindingsReportStatusRequest,
        AwsError,
        zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly
      ]
  object ListAccountPermissions
      extends Stream[
        ListAccountPermissionsRequest,
        AwsError,
        zio.aws.inspector2.model.Permission.ReadOnly
      ]
  object ListAccountPermissionsPaginated
      extends Effect[
        ListAccountPermissionsRequest,
        AwsError,
        zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly
      ]
  object ListCoverageStatistics
      extends Stream[
        ListCoverageStatisticsRequest,
        AwsError,
        zio.aws.inspector2.model.Counts.ReadOnly
      ]
  object ListCoverageStatisticsPaginated
      extends Effect[
        ListCoverageStatisticsRequest,
        AwsError,
        zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly
      ]
  object ListUsageTotals
      extends Stream[
        ListUsageTotalsRequest,
        AwsError,
        zio.aws.inspector2.model.UsageTotal.ReadOnly
      ]
  object ListUsageTotalsPaginated
      extends Effect[ListUsageTotalsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, Inspector2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Inspector2] { rts =>
        zio.ZIO.succeed {
          new Inspector2 {
            val api: Inspector2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Inspector2 = this
            def enable(
                request: EnableRequest
            ): IO[AwsError, zio.aws.inspector2.model.EnableResponse.ReadOnly] =
              proxy(Enable, request)
            def listFindings(request: ListFindingsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.Finding.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFindings, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFindingsPaginated(request: ListFindingsRequest): IO[
              AwsError,
              zio.aws.inspector2.model.ListFindingsResponse.ReadOnly
            ] = proxy(ListFindingsPaginated, request)
            def enableDelegatedAdminAccount(
                request: EnableDelegatedAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly
            ] = proxy(EnableDelegatedAdminAccount, request)
            def listCoverage(request: ListCoverageRequest): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.CoveredResource.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCoverage, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCoveragePaginated(request: ListCoverageRequest): IO[
              AwsError,
              zio.aws.inspector2.model.ListCoverageResponse.ReadOnly
            ] = proxy(ListCoveragePaginated, request)
            def disable(
                request: DisableRequest
            ): IO[AwsError, zio.aws.inspector2.model.DisableResponse.ReadOnly] =
              proxy(Disable, request)
            def updateOrganizationConfiguration(
                request: UpdateOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.ReadOnly
            ] = proxy(UpdateOrganizationConfiguration, request)
            def deleteFilter(request: DeleteFilterRequest): IO[
              AwsError,
              zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly
            ] = proxy(DeleteFilter, request)
            def disassociateMember(request: DisassociateMemberRequest): IO[
              AwsError,
              zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly
            ] = proxy(DisassociateMember, request)
            def disableDelegatedAdminAccount(
                request: DisableDelegatedAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly
            ] = proxy(DisableDelegatedAdminAccount, request)
            def createFilter(request: CreateFilterRequest): IO[
              AwsError,
              zio.aws.inspector2.model.CreateFilterResponse.ReadOnly
            ] = proxy(CreateFilter, request)
            def listMembers(request: ListMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.Member.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMembersPaginated(request: ListMembersRequest): IO[
              AwsError,
              zio.aws.inspector2.model.ListMembersResponse.ReadOnly
            ] = proxy(ListMembersPaginated, request)
            def listFindingAggregations(
                request: ListFindingAggregationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.AggregationResponse.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFindingAggregations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFindingAggregationsPaginated(
                request: ListFindingAggregationsRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly
            ] = proxy(ListFindingAggregationsPaginated, request)
            def cancelFindingsReport(request: CancelFindingsReportRequest): IO[
              AwsError,
              zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly
            ] = proxy(CancelFindingsReport, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.inspector2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listDelegatedAdminAccounts(
                request: ListDelegatedAdminAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDelegatedAdminAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDelegatedAdminAccountsPaginated(
                request: ListDelegatedAdminAccountsRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly
            ] = proxy(ListDelegatedAdminAccountsPaginated, request)
            def getMember(request: GetMemberRequest): IO[
              AwsError,
              zio.aws.inspector2.model.GetMemberResponse.ReadOnly
            ] = proxy(GetMember, request)
            def listFilters(request: ListFiltersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.Filter.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFilters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFiltersPaginated(request: ListFiltersRequest): IO[
              AwsError,
              zio.aws.inspector2.model.ListFiltersResponse.ReadOnly
            ] = proxy(ListFiltersPaginated, request)
            def describeOrganizationConfiguration(
                request: DescribeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfiguration, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def associateMember(request: AssociateMemberRequest): IO[
              AwsError,
              zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly
            ] = proxy(AssociateMember, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.inspector2.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createFindingsReport(request: CreateFindingsReportRequest): IO[
              AwsError,
              zio.aws.inspector2.model.CreateFindingsReportResponse.ReadOnly
            ] = proxy(CreateFindingsReport, request)
            def batchGetAccountStatus(
                request: BatchGetAccountStatusRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly
            ] = proxy(BatchGetAccountStatus, request)
            def getDelegatedAdminAccount(
                request: GetDelegatedAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly
            ] = proxy(GetDelegatedAdminAccount, request)
            def batchGetFreeTrialInfo(
                request: BatchGetFreeTrialInfoRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly
            ] = proxy(BatchGetFreeTrialInfo, request)
            def updateFilter(request: UpdateFilterRequest): IO[
              AwsError,
              zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly
            ] = proxy(UpdateFilter, request)
            def getFindingsReportStatus(
                request: GetFindingsReportStatusRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly
            ] = proxy(GetFindingsReportStatus, request)
            def listAccountPermissions(
                request: ListAccountPermissionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.Permission.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccountPermissions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccountPermissionsPaginated(
                request: ListAccountPermissionsRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly
            ] = proxy(ListAccountPermissionsPaginated, request)
            def listCoverageStatistics(
                request: ListCoverageStatisticsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.Counts.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCoverageStatistics, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCoverageStatisticsPaginated(
                request: ListCoverageStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly
            ] = proxy(ListCoverageStatisticsPaginated, request)
            def listUsageTotals(request: ListUsageTotalsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.inspector2.model.UsageTotal.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsageTotals, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsageTotalsPaginated(
                request: ListUsageTotalsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListUsageTotalsPaginated, request)
          }
        }
      }
    }
  }
}
