package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait UsageType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.UsageType
}
object UsageType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.UsageType
  ): zio.aws.inspector2.model.UsageType = value match {
    case software.amazon.awssdk.services.inspector2.model.UsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.UsageType.EC2_INSTANCE_HOURS =>
      val r = EC2_INSTANCE_HOURS
      r
    case software.amazon.awssdk.services.inspector2.model.UsageType.ECR_INITIAL_SCAN =>
      val r = ECR_INITIAL_SCAN
      r
    case software.amazon.awssdk.services.inspector2.model.UsageType.ECR_RESCAN =>
      val r = ECR_RESCAN
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.UsageType =
      software.amazon.awssdk.services.inspector2.model.UsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_INSTANCE_HOURS extends zio.aws.inspector2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.UsageType =
      software.amazon.awssdk.services.inspector2.model.UsageType.EC2_INSTANCE_HOURS
  }
  case object ECR_INITIAL_SCAN extends zio.aws.inspector2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.UsageType =
      software.amazon.awssdk.services.inspector2.model.UsageType.ECR_INITIAL_SCAN
  }
  case object ECR_RESCAN extends zio.aws.inspector2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.UsageType =
      software.amazon.awssdk.services.inspector2.model.UsageType.ECR_RESCAN
  }
}
