package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCoverageStatisticsResponse(
    countsByGroup: Optional[Iterable[zio.aws.inspector2.model.Counts]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCounts: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse = {
    import ListCoverageStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse
      .builder()
      .optionallyWith(
        countsByGroup.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.countsByGroup)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .totalCounts(totalCounts: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly =
    zio.aws.inspector2.model.ListCoverageStatisticsResponse
      .wrap(buildAwsValue())
}
object ListCoverageStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCoverageStatisticsResponse =
      zio.aws.inspector2.model.ListCoverageStatisticsResponse(
        countsByGroup.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCounts
      )
    def countsByGroup: Optional[List[zio.aws.inspector2.model.Counts.ReadOnly]]
    def nextToken: Optional[NextToken]
    def totalCounts: Long
    def getCountsByGroup
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Counts.ReadOnly]] =
      AwsError.unwrapOptionField("countsByGroup", countsByGroup)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCounts: ZIO[Any, Nothing, Long] = ZIO.succeed(totalCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse
  ) extends zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly {
    override val countsByGroup
        : Optional[List[zio.aws.inspector2.model.Counts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countsByGroup())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Counts.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val totalCounts: Long = impl.totalCounts(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse
  ): zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
