package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class TitleAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent,
    title: NonEmptyString,
    vulnerabilityId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse = {
    import TitleAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .title(NonEmptyString.unwrap(title): java.lang.String)
      .optionallyWith(vulnerabilityId.map(value => value: java.lang.String))(
        _.vulnerabilityId
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.TitleAggregationResponse.wrap(buildAwsValue())
}
object TitleAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TitleAggregationResponse =
      zio.aws.inspector2.model.TitleAggregationResponse(
        accountId.map(value => value),
        severityCounts.map(value => value.asEditable),
        title,
        vulnerabilityId.map(value => value)
      )
    def accountId: Optional[AccountId]
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def title: NonEmptyString
    def vulnerabilityId: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
    def getTitle: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(title)
    def getVulnerabilityId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vulnerabilityId", vulnerabilityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ) extends zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
    override val title: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.title())
    override val vulnerabilityId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vulnerabilityId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregationResponse
  ): zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
