package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListAccountPermissionsMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccountPermissionsRequest(
    maxResults: Optional[ListAccountPermissionsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    service: Optional[zio.aws.inspector2.model.Service] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest = {
    import ListAccountPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAccountPermissionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(service.map(value => value.unwrap))(_.service)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly =
    zio.aws.inspector2.model.ListAccountPermissionsRequest.wrap(buildAwsValue())
}
object ListAccountPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListAccountPermissionsRequest =
      zio.aws.inspector2.model.ListAccountPermissionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        service.map(value => value)
      )
    def maxResults: Optional[ListAccountPermissionsMaxResults]
    def nextToken: Optional[NextToken]
    def service: Optional[zio.aws.inspector2.model.Service]
    def getMaxResults: ZIO[Any, AwsError, ListAccountPermissionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getService: ZIO[Any, AwsError, zio.aws.inspector2.model.Service] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ) extends zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly {
    override val maxResults: Optional[ListAccountPermissionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .ListAccountPermissionsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val service: Optional[zio.aws.inspector2.model.Service] =
      zio.aws.core.internal
        .optionalFromNullable(impl.service())
        .map(value => zio.aws.inspector2.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ): zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
