package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DisassociateMemberResponse(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse = {
    import DisassociateMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly =
    zio.aws.inspector2.model.DisassociateMemberResponse.wrap(buildAwsValue())
}
object DisassociateMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DisassociateMemberResponse =
      zio.aws.inspector2.model.DisassociateMemberResponse(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse
  ) extends zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse
  ): zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
