package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmiAggregation(
    amis: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.AmiSortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AmiAggregation = {
    import AmiAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AmiAggregation
      .builder()
      .optionallyWith(
        amis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.amis)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AmiAggregation.ReadOnly =
    zio.aws.inspector2.model.AmiAggregation.wrap(buildAwsValue())
}
object AmiAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AmiAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AmiAggregation =
      zio.aws.inspector2.model.AmiAggregation(
        amis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def amis: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.AmiSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getAmis: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("amis", amis)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.AmiSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AmiAggregation
  ) extends zio.aws.inspector2.model.AmiAggregation.ReadOnly {
    override val amis
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amis())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[zio.aws.inspector2.model.AmiSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.AmiSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AmiAggregation
  ): zio.aws.inspector2.model.AmiAggregation.ReadOnly = new Wrapper(impl)
}
