package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AggregationRequest(
    accountAggregation: Option[zio.aws.inspector2.model.AccountAggregation] =
      None,
    amiAggregation: Option[zio.aws.inspector2.model.AmiAggregation] = None,
    awsEcrContainerAggregation: Option[
      zio.aws.inspector2.model.AwsEcrContainerAggregation
    ] = None,
    ec2InstanceAggregation: Option[
      zio.aws.inspector2.model.Ec2InstanceAggregation
    ] = None,
    findingTypeAggregation: Option[
      zio.aws.inspector2.model.FindingTypeAggregation
    ] = None,
    imageLayerAggregation: Option[
      zio.aws.inspector2.model.ImageLayerAggregation
    ] = None,
    packageAggregation: Option[zio.aws.inspector2.model.PackageAggregation] =
      None,
    repositoryAggregation: Option[
      zio.aws.inspector2.model.RepositoryAggregation
    ] = None,
    titleAggregation: Option[zio.aws.inspector2.model.TitleAggregation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AggregationRequest = {
    import AggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AggregationRequest
      .builder()
      .optionallyWith(accountAggregation.map(value => value.buildAwsValue()))(
        _.accountAggregation
      )
      .optionallyWith(amiAggregation.map(value => value.buildAwsValue()))(
        _.amiAggregation
      )
      .optionallyWith(
        awsEcrContainerAggregation.map(value => value.buildAwsValue())
      )(_.awsEcrContainerAggregation)
      .optionallyWith(
        ec2InstanceAggregation.map(value => value.buildAwsValue())
      )(_.ec2InstanceAggregation)
      .optionallyWith(
        findingTypeAggregation.map(value => value.buildAwsValue())
      )(_.findingTypeAggregation)
      .optionallyWith(
        imageLayerAggregation.map(value => value.buildAwsValue())
      )(_.imageLayerAggregation)
      .optionallyWith(packageAggregation.map(value => value.buildAwsValue()))(
        _.packageAggregation
      )
      .optionallyWith(
        repositoryAggregation.map(value => value.buildAwsValue())
      )(_.repositoryAggregation)
      .optionallyWith(titleAggregation.map(value => value.buildAwsValue()))(
        _.titleAggregation
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AggregationRequest.ReadOnly =
    zio.aws.inspector2.model.AggregationRequest.wrap(buildAwsValue())
}
object AggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AggregationRequest =
      zio.aws.inspector2.model.AggregationRequest(
        accountAggregation.map(value => value.asEditable),
        amiAggregation.map(value => value.asEditable),
        awsEcrContainerAggregation.map(value => value.asEditable),
        ec2InstanceAggregation.map(value => value.asEditable),
        findingTypeAggregation.map(value => value.asEditable),
        imageLayerAggregation.map(value => value.asEditable),
        packageAggregation.map(value => value.asEditable),
        repositoryAggregation.map(value => value.asEditable),
        titleAggregation.map(value => value.asEditable)
      )
    def accountAggregation
        : Option[zio.aws.inspector2.model.AccountAggregation.ReadOnly]
    def amiAggregation: Option[zio.aws.inspector2.model.AmiAggregation.ReadOnly]
    def awsEcrContainerAggregation
        : Option[zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly]
    def ec2InstanceAggregation
        : Option[zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly]
    def findingTypeAggregation
        : Option[zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly]
    def imageLayerAggregation
        : Option[zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly]
    def packageAggregation
        : Option[zio.aws.inspector2.model.PackageAggregation.ReadOnly]
    def repositoryAggregation
        : Option[zio.aws.inspector2.model.RepositoryAggregation.ReadOnly]
    def titleAggregation
        : Option[zio.aws.inspector2.model.TitleAggregation.ReadOnly]
    def getAccountAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AccountAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("accountAggregation", accountAggregation)
    def getAmiAggregation
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AmiAggregation.ReadOnly] =
      AwsError.unwrapOptionField("amiAggregation", amiAggregation)
    def getAwsEcrContainerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEcrContainerAggregation",
      awsEcrContainerAggregation
    )
    def getEc2InstanceAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2InstanceAggregation",
      ec2InstanceAggregation
    )
    def getFindingTypeAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "findingTypeAggregation",
      findingTypeAggregation
    )
    def getImageLayerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly
    ] =
      AwsError.unwrapOptionField("imageLayerAggregation", imageLayerAggregation)
    def getPackageAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.PackageAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("packageAggregation", packageAggregation)
    def getRepositoryAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.RepositoryAggregation.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAggregation", repositoryAggregation)
    def getTitleAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.TitleAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("titleAggregation", titleAggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ) extends zio.aws.inspector2.model.AggregationRequest.ReadOnly {
    override val accountAggregation
        : Option[zio.aws.inspector2.model.AccountAggregation.ReadOnly] = scala
      .Option(impl.accountAggregation())
      .map(value => zio.aws.inspector2.model.AccountAggregation.wrap(value))
    override val amiAggregation
        : Option[zio.aws.inspector2.model.AmiAggregation.ReadOnly] = scala
      .Option(impl.amiAggregation())
      .map(value => zio.aws.inspector2.model.AmiAggregation.wrap(value))
    override val awsEcrContainerAggregation
        : Option[zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly] =
      scala
        .Option(impl.awsEcrContainerAggregation())
        .map(value =>
          zio.aws.inspector2.model.AwsEcrContainerAggregation.wrap(value)
        )
    override val ec2InstanceAggregation
        : Option[zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly] =
      scala
        .Option(impl.ec2InstanceAggregation())
        .map(value =>
          zio.aws.inspector2.model.Ec2InstanceAggregation.wrap(value)
        )
    override val findingTypeAggregation
        : Option[zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly] =
      scala
        .Option(impl.findingTypeAggregation())
        .map(value =>
          zio.aws.inspector2.model.FindingTypeAggregation.wrap(value)
        )
    override val imageLayerAggregation
        : Option[zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly] =
      scala
        .Option(impl.imageLayerAggregation())
        .map(value =>
          zio.aws.inspector2.model.ImageLayerAggregation.wrap(value)
        )
    override val packageAggregation
        : Option[zio.aws.inspector2.model.PackageAggregation.ReadOnly] = scala
      .Option(impl.packageAggregation())
      .map(value => zio.aws.inspector2.model.PackageAggregation.wrap(value))
    override val repositoryAggregation
        : Option[zio.aws.inspector2.model.RepositoryAggregation.ReadOnly] =
      scala
        .Option(impl.repositoryAggregation())
        .map(value =>
          zio.aws.inspector2.model.RepositoryAggregation.wrap(value)
        )
    override val titleAggregation
        : Option[zio.aws.inspector2.model.TitleAggregation.ReadOnly] = scala
      .Option(impl.titleAggregation())
      .map(value => zio.aws.inspector2.model.TitleAggregation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ): zio.aws.inspector2.model.AggregationRequest.ReadOnly = new Wrapper(impl)
}
