package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListAccountPermissionsMaxResults
}
import scala.jdk.CollectionConverters._
final case class ListAccountPermissionsRequest(
    maxResults: Option[ListAccountPermissionsMaxResults] = None,
    nextToken: Option[NextToken] = None,
    service: Option[zio.aws.inspector2.model.Service] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest = {
    import ListAccountPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAccountPermissionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(service.map(value => value.unwrap))(_.service)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly =
    zio.aws.inspector2.model.ListAccountPermissionsRequest.wrap(buildAwsValue())
}
object ListAccountPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListAccountPermissionsRequest =
      zio.aws.inspector2.model.ListAccountPermissionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        service.map(value => value)
      )
    def maxResults: Option[ListAccountPermissionsMaxResults]
    def nextToken: Option[NextToken]
    def service: Option[zio.aws.inspector2.model.Service]
    def getMaxResults: ZIO[Any, AwsError, ListAccountPermissionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getService: ZIO[Any, AwsError, zio.aws.inspector2.model.Service] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ) extends zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly {
    override val maxResults: Option[ListAccountPermissionsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector2.model.primitives
          .ListAccountPermissionsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val service: Option[zio.aws.inspector2.model.Service] = scala
      .Option(impl.service())
      .map(value => zio.aws.inspector2.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest
  ): zio.aws.inspector2.model.ListAccountPermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
