package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{ResourceId, AccountId}
import scala.jdk.CollectionConverters._
final case class CoveredResource(
    accountId: AccountId,
    resourceId: ResourceId,
    resourceMetadata: Option[zio.aws.inspector2.model.ResourceScanMetadata] =
      None,
    resourceType: zio.aws.inspector2.model.CoverageResourceType,
    scanStatus: Option[zio.aws.inspector2.model.ScanStatus] = None,
    scanType: zio.aws.inspector2.model.ScanType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoveredResource = {
    import CoveredResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoveredResource
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(resourceMetadata.map(value => value.buildAwsValue()))(
        _.resourceMetadata
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(scanStatus.map(value => value.buildAwsValue()))(
        _.scanStatus
      )
      .scanType(scanType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoveredResource.ReadOnly =
    zio.aws.inspector2.model.CoveredResource.wrap(buildAwsValue())
}
object CoveredResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoveredResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoveredResource =
      zio.aws.inspector2.model.CoveredResource(
        accountId,
        resourceId,
        resourceMetadata.map(value => value.asEditable),
        resourceType,
        scanStatus.map(value => value.asEditable),
        scanType
      )
    def accountId: AccountId
    def resourceId: ResourceId
    def resourceMetadata
        : Option[zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly]
    def resourceType: zio.aws.inspector2.model.CoverageResourceType
    def scanStatus: Option[zio.aws.inspector2.model.ScanStatus.ReadOnly]
    def scanType: zio.aws.inspector2.model.ScanType
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("resourceMetadata", resourceMetadata)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CoverageResourceType] =
      ZIO.succeed(resourceType)
    def getScanStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ScanStatus.ReadOnly] =
      AwsError.unwrapOptionField("scanStatus", scanStatus)
    def getScanType: ZIO[Any, Nothing, zio.aws.inspector2.model.ScanType] =
      ZIO.succeed(scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoveredResource
  ) extends zio.aws.inspector2.model.CoveredResource.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val resourceId: ResourceId =
      zio.aws.inspector2.model.primitives.ResourceId(impl.resourceId())
    override val resourceMetadata
        : Option[zio.aws.inspector2.model.ResourceScanMetadata.ReadOnly] = scala
      .Option(impl.resourceMetadata())
      .map(value => zio.aws.inspector2.model.ResourceScanMetadata.wrap(value))
    override val resourceType: zio.aws.inspector2.model.CoverageResourceType =
      zio.aws.inspector2.model.CoverageResourceType.wrap(impl.resourceType())
    override val scanStatus
        : Option[zio.aws.inspector2.model.ScanStatus.ReadOnly] = scala
      .Option(impl.scanStatus())
      .map(value => zio.aws.inspector2.model.ScanStatus.wrap(value))
    override val scanType: zio.aws.inspector2.model.ScanType =
      zio.aws.inspector2.model.ScanType.wrap(impl.scanType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoveredResource
  ): zio.aws.inspector2.model.CoveredResource.ReadOnly = new Wrapper(impl)
}
