package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{MapValue, MapKey}
import scala.jdk.CollectionConverters._
final case class MapFilter(
    comparison: zio.aws.inspector2.model.MapComparison,
    key: MapKey,
    value: Option[MapValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.MapFilter = {
    import MapFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.MapFilter
      .builder()
      .comparison(comparison.unwrap)
      .key(MapKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => MapValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.MapFilter.ReadOnly =
    zio.aws.inspector2.model.MapFilter.wrap(buildAwsValue())
}
object MapFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.MapFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.MapFilter =
      zio.aws.inspector2.model
        .MapFilter(comparison, key, value.map(value => value))
    def comparison: zio.aws.inspector2.model.MapComparison
    def key: MapKey
    def value: Option[MapValue]
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.MapComparison] =
      ZIO.succeed(comparison)
    def getKey: ZIO[Any, Nothing, MapKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, MapValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.MapFilter
  ) extends zio.aws.inspector2.model.MapFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.MapComparison =
      zio.aws.inspector2.model.MapComparison.wrap(impl.comparison())
    override val key: MapKey =
      zio.aws.inspector2.model.primitives.MapKey(impl.key())
    override val value: Option[MapValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.inspector2.model.primitives.MapValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.MapFilter
  ): zio.aws.inspector2.model.MapFilter.ReadOnly = new Wrapper(impl)
}
