package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{MapValue, MapKey}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Map[MapKey, MapValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.inspector2.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListTagsForResourceResponse =
      zio.aws.inspector2.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[MapKey, MapValue]]
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse
  ) extends zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[MapKey, MapValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse
  ): zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
