package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableResponse(
    accounts: Iterable[zio.aws.inspector2.model.Account],
    failedAccounts: Option[Iterable[zio.aws.inspector2.model.FailedAccount]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EnableResponse = {
    import EnableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EnableResponse
      .builder()
      .accounts(accounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        failedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EnableResponse.ReadOnly =
    zio.aws.inspector2.model.EnableResponse.wrap(buildAwsValue())
}
object EnableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EnableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EnableResponse =
      zio.aws.inspector2.model.EnableResponse(
        accounts.map { item =>
          item.asEditable
        },
        failedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts: List[zio.aws.inspector2.model.Account.ReadOnly]
    def failedAccounts
        : Option[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]]
    def getAccounts
        : ZIO[Any, Nothing, List[zio.aws.inspector2.model.Account.ReadOnly]] =
      ZIO.succeed(accounts)
    def getFailedAccounts: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FailedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("failedAccounts", failedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EnableResponse
  ) extends zio.aws.inspector2.model.EnableResponse.ReadOnly {
    override val accounts: List[zio.aws.inspector2.model.Account.ReadOnly] =
      impl
        .accounts()
        .asScala
        .map { item =>
          zio.aws.inspector2.model.Account.wrap(item)
        }
        .toList
    override val failedAccounts
        : Option[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]] = scala
      .Option(impl.failedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.FailedAccount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EnableResponse
  ): zio.aws.inspector2.model.EnableResponse.ReadOnly = new Wrapper(impl)
}
