package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DisassociateMemberRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest = {
    import DisassociateMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DisassociateMemberRequest.ReadOnly =
    zio.aws.inspector2.model.DisassociateMemberRequest.wrap(buildAwsValue())
}
object DisassociateMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DisassociateMemberRequest =
      zio.aws.inspector2.model.DisassociateMemberRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest
  ) extends zio.aws.inspector2.model.DisassociateMemberRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest
  ): zio.aws.inspector2.model.DisassociateMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
