package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class State(
    errorCode: zio.aws.inspector2.model.ErrorCode,
    errorMessage: NonEmptyString,
    status: zio.aws.inspector2.model.Status
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.State = {
    import State.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.State
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(NonEmptyString.unwrap(errorMessage): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.State.ReadOnly =
    zio.aws.inspector2.model.State.wrap(buildAwsValue())
}
object State {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.State] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.State =
      zio.aws.inspector2.model.State(errorCode, errorMessage, status)
    def errorCode: zio.aws.inspector2.model.ErrorCode
    def errorMessage: NonEmptyString
    def status: zio.aws.inspector2.model.Status
    def getErrorCode: ZIO[Any, Nothing, zio.aws.inspector2.model.ErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(errorMessage)
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.State
  ) extends zio.aws.inspector2.model.State.ReadOnly {
    override val errorCode: zio.aws.inspector2.model.ErrorCode =
      zio.aws.inspector2.model.ErrorCode.wrap(impl.errorCode())
    override val errorMessage: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.errorMessage())
    override val status: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.State
  ): zio.aws.inspector2.model.State.ReadOnly = new Wrapper(impl)
}
