package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFindingsResponse(
    findings: Option[Iterable[zio.aws.inspector2.model.Finding]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFindingsResponse = {
    import ListFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFindingsResponse
      .builder()
      .optionallyWith(
        findings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListFindingsResponse.ReadOnly =
    zio.aws.inspector2.model.ListFindingsResponse.wrap(buildAwsValue())
}
object ListFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFindingsResponse =
      zio.aws.inspector2.model.ListFindingsResponse(
        findings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findings: Option[List[zio.aws.inspector2.model.Finding.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFindings
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Finding.ReadOnly]] =
      AwsError.unwrapOptionField("findings", findings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingsResponse
  ) extends zio.aws.inspector2.model.ListFindingsResponse.ReadOnly {
    override val findings
        : Option[List[zio.aws.inspector2.model.Finding.ReadOnly]] = scala
      .Option(impl.findings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.Finding.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingsResponse
  ): zio.aws.inspector2.model.ListFindingsResponse.ReadOnly = new Wrapper(impl)
}
