package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class GetMemberRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetMemberRequest = {
    import GetMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetMemberRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetMemberRequest.ReadOnly =
    zio.aws.inspector2.model.GetMemberRequest.wrap(buildAwsValue())
}
object GetMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetMemberRequest =
      zio.aws.inspector2.model.GetMemberRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetMemberRequest
  ) extends zio.aws.inspector2.model.GetMemberRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetMemberRequest
  ): zio.aws.inspector2.model.GetMemberRequest.ReadOnly = new Wrapper(impl)
}
