package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DelegatedAdmin(
    accountId: Option[AccountId] = None,
    relationshipStatus: Option[zio.aws.inspector2.model.RelationshipStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DelegatedAdmin = {
    import DelegatedAdmin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DelegatedAdmin
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DelegatedAdmin.ReadOnly =
    zio.aws.inspector2.model.DelegatedAdmin.wrap(buildAwsValue())
}
object DelegatedAdmin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DelegatedAdmin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DelegatedAdmin =
      zio.aws.inspector2.model.DelegatedAdmin(
        accountId.map(value => value),
        relationshipStatus.map(value => value)
      )
    def accountId: Option[AccountId]
    def relationshipStatus: Option[zio.aws.inspector2.model.RelationshipStatus]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DelegatedAdmin
  ) extends zio.aws.inspector2.model.DelegatedAdmin.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val relationshipStatus
        : Option[zio.aws.inspector2.model.RelationshipStatus] = scala
      .Option(impl.relationshipStatus())
      .map(value => zio.aws.inspector2.model.RelationshipStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DelegatedAdmin
  ): zio.aws.inspector2.model.DelegatedAdmin.ReadOnly = new Wrapper(impl)
}
