package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class AwsEcrContainerAggregationResponse(
    accountId: Option[AccountId] = None,
    architecture: Option[String] = None,
    imageSha: Option[String] = None,
    imageTags: Option[Iterable[NonEmptyString]] = None,
    repository: Option[String] = None,
    resourceId: NonEmptyString,
    severityCounts: Option[zio.aws.inspector2.model.SeverityCounts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse = {
    import AwsEcrContainerAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(imageSha.map(value => value: java.lang.String))(
        _.imageSha
      )
      .optionallyWith(
        imageTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageTags)
      .optionallyWith(repository.map(value => value: java.lang.String))(
        _.repository
      )
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AwsEcrContainerAggregationResponse
      .wrap(buildAwsValue())
}
object AwsEcrContainerAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.AwsEcrContainerAggregationResponse =
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse(
        accountId.map(value => value),
        architecture.map(value => value),
        imageSha.map(value => value),
        imageTags.map(value => value),
        repository.map(value => value),
        resourceId,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Option[AccountId]
    def architecture: Option[String]
    def imageSha: Option[String]
    def imageTags: Option[List[NonEmptyString]]
    def repository: Option[String]
    def resourceId: NonEmptyString
    def severityCounts: Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getImageSha: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageSha", imageSha)
    def getImageTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageTags", imageTags)
    def getRepository: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("repository", repository)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ) extends zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val architecture: Option[String] =
      scala.Option(impl.architecture()).map(value => value: String)
    override val imageSha: Option[String] =
      scala.Option(impl.imageSha()).map(value => value: String)
    override val imageTags: Option[List[NonEmptyString]] = scala
      .Option(impl.imageTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val repository: Option[String] =
      scala.Option(impl.repository()).map(value => value: String)
    override val resourceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.resourceId())
    override val severityCounts
        : Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly] = scala
      .Option(impl.severityCounts())
      .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ): zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
