package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PackageFilter(
    architecture: Option[zio.aws.inspector2.model.StringFilter] = None,
    epoch: Option[zio.aws.inspector2.model.NumberFilter] = None,
    name: Option[zio.aws.inspector2.model.StringFilter] = None,
    release: Option[zio.aws.inspector2.model.StringFilter] = None,
    sourceLayerHash: Option[zio.aws.inspector2.model.StringFilter] = None,
    version: Option[zio.aws.inspector2.model.StringFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageFilter = {
    import PackageFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageFilter
      .builder()
      .optionallyWith(architecture.map(value => value.buildAwsValue()))(
        _.architecture
      )
      .optionallyWith(epoch.map(value => value.buildAwsValue()))(_.epoch)
      .optionallyWith(name.map(value => value.buildAwsValue()))(_.name)
      .optionallyWith(release.map(value => value.buildAwsValue()))(_.release)
      .optionallyWith(sourceLayerHash.map(value => value.buildAwsValue()))(
        _.sourceLayerHash
      )
      .optionallyWith(version.map(value => value.buildAwsValue()))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PackageFilter.ReadOnly =
    zio.aws.inspector2.model.PackageFilter.wrap(buildAwsValue())
}
object PackageFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageFilter =
      zio.aws.inspector2.model.PackageFilter(
        architecture.map(value => value.asEditable),
        epoch.map(value => value.asEditable),
        name.map(value => value.asEditable),
        release.map(value => value.asEditable),
        sourceLayerHash.map(value => value.asEditable),
        version.map(value => value.asEditable)
      )
    def architecture: Option[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def epoch: Option[zio.aws.inspector2.model.NumberFilter.ReadOnly]
    def name: Option[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def release: Option[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def sourceLayerHash: Option[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def version: Option[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getEpoch
        : ZIO[Any, AwsError, zio.aws.inspector2.model.NumberFilter.ReadOnly] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getName
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("name", name)
    def getRelease
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("release", release)
    def getSourceLayerHash
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("sourceLayerHash", sourceLayerHash)
    def getVersion
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageFilter
  ) extends zio.aws.inspector2.model.PackageFilter.ReadOnly {
    override val architecture
        : Option[zio.aws.inspector2.model.StringFilter.ReadOnly] = scala
      .Option(impl.architecture())
      .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val epoch: Option[zio.aws.inspector2.model.NumberFilter.ReadOnly] =
      scala
        .Option(impl.epoch())
        .map(value => zio.aws.inspector2.model.NumberFilter.wrap(value))
    override val name: Option[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      scala
        .Option(impl.name())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val release
        : Option[zio.aws.inspector2.model.StringFilter.ReadOnly] = scala
      .Option(impl.release())
      .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val sourceLayerHash
        : Option[zio.aws.inspector2.model.StringFilter.ReadOnly] = scala
      .Option(impl.sourceLayerHash())
      .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val version
        : Option[zio.aws.inspector2.model.StringFilter.ReadOnly] = scala
      .Option(impl.version())
      .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageFilter
  ): zio.aws.inspector2.model.PackageFilter.ReadOnly = new Wrapper(impl)
}
