package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.Port
import scala.jdk.CollectionConverters._
final case class PortRangeFilter(
    beginInclusive: Option[Port] = None,
    endInclusive: Option[Port] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PortRangeFilter = {
    import PortRangeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PortRangeFilter
      .builder()
      .optionallyWith(beginInclusive.map(value => Port.unwrap(value): Integer))(
        _.beginInclusive
      )
      .optionallyWith(endInclusive.map(value => Port.unwrap(value): Integer))(
        _.endInclusive
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PortRangeFilter.ReadOnly =
    zio.aws.inspector2.model.PortRangeFilter.wrap(buildAwsValue())
}
object PortRangeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PortRangeFilter =
      zio.aws.inspector2.model.PortRangeFilter(
        beginInclusive.map(value => value),
        endInclusive.map(value => value)
      )
    def beginInclusive: Option[Port]
    def endInclusive: Option[Port]
    def getBeginInclusive: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("beginInclusive", beginInclusive)
    def getEndInclusive: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("endInclusive", endInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ) extends zio.aws.inspector2.model.PortRangeFilter.ReadOnly {
    override val beginInclusive: Option[Port] = scala
      .Option(impl.beginInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Port(value))
    override val endInclusive: Option[Port] = scala
      .Option(impl.endInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PortRangeFilter
  ): zio.aws.inspector2.model.PortRangeFilter.ReadOnly = new Wrapper(impl)
}
