package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class DateFilter(
    endInclusive: Option[Timestamp] = None,
    startInclusive: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DateFilter = {
    import DateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DateFilter
      .builder()
      .optionallyWith(
        endInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.endInclusive)
      .optionallyWith(
        startInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.startInclusive)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DateFilter.ReadOnly =
    zio.aws.inspector2.model.DateFilter.wrap(buildAwsValue())
}
object DateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DateFilter =
      zio.aws.inspector2.model.DateFilter(
        endInclusive.map(value => value),
        startInclusive.map(value => value)
      )
    def endInclusive: Option[Timestamp]
    def startInclusive: Option[Timestamp]
    def getEndInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endInclusive", endInclusive)
    def getStartInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startInclusive", startInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DateFilter
  ) extends zio.aws.inspector2.model.DateFilter.ReadOnly {
    override val endInclusive: Option[Timestamp] = scala
      .Option(impl.endInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
    override val startInclusive: Option[Timestamp] = scala
      .Option(impl.startInclusive())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DateFilter
  ): zio.aws.inspector2.model.DateFilter.ReadOnly = new Wrapper(impl)
}
