package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageLayerAggregation(
    layerHashes: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    repositories: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    resourceIds: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    sortBy: Option[zio.aws.inspector2.model.ImageLayerSortBy] = None,
    sortOrder: Option[zio.aws.inspector2.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation = {
    import ImageLayerAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
      .builder()
      .optionallyWith(
        layerHashes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layerHashes)
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly =
    zio.aws.inspector2.model.ImageLayerAggregation.wrap(buildAwsValue())
}
object ImageLayerAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ImageLayerAggregation =
      zio.aws.inspector2.model.ImageLayerAggregation(
        layerHashes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def layerHashes
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def repositories
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceIds
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Option[zio.aws.inspector2.model.ImageLayerSortBy]
    def sortOrder: Option[zio.aws.inspector2.model.SortOrder]
    def getLayerHashes: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("layerHashes", layerHashes)
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getResourceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ImageLayerSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ) extends zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly {
    override val layerHashes
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.layerHashes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val repositories
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.repositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceIds
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val sortBy: Option[zio.aws.inspector2.model.ImageLayerSortBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.inspector2.model.ImageLayerSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.inspector2.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ): zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly = new Wrapper(impl)
}
