package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  MapValue,
  MapKey,
  NonEmptyString,
  AmiId
}
import scala.jdk.CollectionConverters._
final case class Ec2InstanceAggregationResponse(
    accountId: Option[String] = None,
    ami: Option[AmiId] = None,
    instanceId: NonEmptyString,
    instanceTags: Option[Map[MapKey, MapValue]] = None,
    networkFindings: Option[Long] = None,
    operatingSystem: Option[String] = None,
    severityCounts: Option[zio.aws.inspector2.model.SeverityCounts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse = {
    import Ec2InstanceAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(ami.map(value => AmiId.unwrap(value): java.lang.String))(
        _.ami
      )
      .instanceId(NonEmptyString.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        instanceTags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.instanceTags)
      .optionallyWith(networkFindings.map(value => value: java.lang.Long))(
        _.networkFindings
      )
      .optionallyWith(operatingSystem.map(value => value: java.lang.String))(
        _.operatingSystem
      )
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.Ec2InstanceAggregationResponse
      .wrap(buildAwsValue())
}
object Ec2InstanceAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2InstanceAggregationResponse =
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse(
        accountId.map(value => value),
        ami.map(value => value),
        instanceId,
        instanceTags.map(value => value),
        networkFindings.map(value => value),
        operatingSystem.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Option[String]
    def ami: Option[AmiId]
    def instanceId: NonEmptyString
    def instanceTags: Option[Map[MapKey, MapValue]]
    def networkFindings: Option[Long]
    def operatingSystem: Option[String]
    def severityCounts: Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAmi: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("ami", ami)
    def getInstanceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(instanceId)
    def getInstanceTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("instanceTags", instanceTags)
    def getNetworkFindings: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("networkFindings", networkFindings)
    def getOperatingSystem: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ) extends zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly {
    override val accountId: Option[String] =
      scala.Option(impl.accountId()).map(value => value: String)
    override val ami: Option[AmiId] = scala
      .Option(impl.ami())
      .map(value => zio.aws.inspector2.model.primitives.AmiId(value))
    override val instanceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.instanceId())
    override val instanceTags: Option[Map[MapKey, MapValue]] = scala
      .Option(impl.instanceTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
    override val networkFindings: Option[Long] =
      scala.Option(impl.networkFindings()).map(value => value: Long)
    override val operatingSystem: Option[String] =
      scala.Option(impl.operatingSystem()).map(value => value: String)
    override val severityCounts
        : Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly] = scala
      .Option(impl.severityCounts())
      .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ): zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
