package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.MeteringAccountId
import scala.jdk.CollectionConverters._
final case class UsageTotal(
    accountId: Option[MeteringAccountId] = None,
    usage: Option[Iterable[zio.aws.inspector2.model.Usage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UsageTotal = {
    import UsageTotal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UsageTotal
      .builder()
      .optionallyWith(
        accountId.map(value =>
          MeteringAccountId.unwrap(value): java.lang.String
        )
      )(_.accountId)
      .optionallyWith(
        usage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usage)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UsageTotal.ReadOnly =
    zio.aws.inspector2.model.UsageTotal.wrap(buildAwsValue())
}
object UsageTotal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UsageTotal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UsageTotal =
      zio.aws.inspector2.model.UsageTotal(
        accountId.map(value => value),
        usage.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId: Option[MeteringAccountId]
    def usage: Option[List[zio.aws.inspector2.model.Usage.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, MeteringAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getUsage
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Usage.ReadOnly]] =
      AwsError.unwrapOptionField("usage", usage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UsageTotal
  ) extends zio.aws.inspector2.model.UsageTotal.ReadOnly {
    override val accountId: Option[MeteringAccountId] = scala
      .Option(impl.accountId())
      .map(value =>
        zio.aws.inspector2.model.primitives.MeteringAccountId(value)
      )
    override val usage: Option[List[zio.aws.inspector2.model.Usage.ReadOnly]] =
      scala
        .Option(impl.usage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Usage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UsageTotal
  ): zio.aws.inspector2.model.UsageTotal.ReadOnly = new Wrapper(impl)
}
