package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.WorkflowType
}
object WorkflowType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.WorkflowType
  ): zio.aws.imagebuilder.model.WorkflowType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowType.BUILD =>
      val r = BUILD
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowType.TEST =>
      val r = TEST
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowType.DISTRIBUTION =>
      val r = DISTRIBUTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILD extends zio.aws.imagebuilder.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowType.BUILD
  }
  case object TEST extends zio.aws.imagebuilder.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowType.TEST
  }
  case object DISTRIBUTION extends zio.aws.imagebuilder.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowType.DISTRIBUTION
  }
}
