package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowStepActionType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType
}
object WorkflowStepActionType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType
  ): zio.aws.imagebuilder.model.WorkflowStepActionType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.RESUME =>
      val r = RESUME
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.STOP =>
      val r = STOP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.WorkflowStepActionType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESUME extends zio.aws.imagebuilder.model.WorkflowStepActionType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.RESUME
  }
  case object STOP extends zio.aws.imagebuilder.model.WorkflowStepActionType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepActionType.STOP
  }
}
