package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus
}
object WorkflowStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus
  ): zio.aws.imagebuilder.model.WorkflowStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus.DEPRECATED =>
      val r = DEPRECATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPRECATED extends zio.aws.imagebuilder.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStatus.DEPRECATED
  }
}
