package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  WorkflowParameterDescription,
  WorkflowParameterValue,
  WorkflowParameterType,
  WorkflowParameterName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowParameterDetail(
    name: WorkflowParameterName,
    `type`: WorkflowParameterType,
    defaultValue: Optional[Iterable[WorkflowParameterValue]] = Optional.Absent,
    description: Optional[WorkflowParameterDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail = {
    import WorkflowParameterDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail
      .builder()
      .name(WorkflowParameterName.unwrap(name): java.lang.String)
      .`type`(WorkflowParameterType.unwrap(`type`): java.lang.String)
      .optionallyWith(
        defaultValue.map(value =>
          value.map { item =>
            WorkflowParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.defaultValue)
      .optionallyWith(
        description.map(value =>
          WorkflowParameterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowParameterDetail.wrap(buildAwsValue())
}
object WorkflowParameterDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowParameterDetail =
      zio.aws.imagebuilder.model.WorkflowParameterDetail(
        name,
        `type`,
        defaultValue.map(value => value),
        description.map(value => value)
      )
    def name: WorkflowParameterName
    def `type`: WorkflowParameterType
    def defaultValue: Optional[List[WorkflowParameterValue]]
    def description: Optional[WorkflowParameterDescription]
    def getName: ZIO[Any, Nothing, WorkflowParameterName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, WorkflowParameterType] = ZIO.succeed(`type`)
    def getDefaultValue: ZIO[Any, AwsError, List[WorkflowParameterValue]] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, WorkflowParameterDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail
  ) extends zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly {
    override val name: WorkflowParameterName =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterName(impl.name())
    override val `type`: WorkflowParameterType =
      zio.aws.imagebuilder.model.primitives.WorkflowParameterType(impl.`type`())
    override val defaultValue: Optional[List[WorkflowParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.WorkflowParameterValue(item)
          }.toList
        )
    override val description: Optional[WorkflowParameterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.imagebuilder.model.primitives
            .WorkflowParameterDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail
  ): zio.aws.imagebuilder.model.WorkflowParameterDetail.ReadOnly = new Wrapper(
    impl
  )
}
