package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ParallelGroup,
  WorkflowVersionArnOrBuildVersionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowConfiguration(
    workflowArn: WorkflowVersionArnOrBuildVersionArn,
    parameters: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowParameter]
    ] = Optional.Absent,
    parallelGroup: Optional[ParallelGroup] = Optional.Absent,
    onFailure: Optional[zio.aws.imagebuilder.model.OnWorkflowFailure] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration = {
    import WorkflowConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration
      .builder()
      .workflowArn(
        WorkflowVersionArnOrBuildVersionArn.unwrap(
          workflowArn
        ): java.lang.String
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        parallelGroup.map(value =>
          ParallelGroup.unwrap(value): java.lang.String
        )
      )(_.parallelGroup)
      .optionallyWith(onFailure.map(value => value.unwrap))(_.onFailure)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.WorkflowConfiguration.wrap(buildAwsValue())
}
object WorkflowConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.WorkflowConfiguration =
      zio.aws.imagebuilder.model.WorkflowConfiguration(
        workflowArn,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parallelGroup.map(value => value),
        onFailure.map(value => value)
      )
    def workflowArn: WorkflowVersionArnOrBuildVersionArn
    def parameters
        : Optional[List[zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly]]
    def parallelGroup: Optional[ParallelGroup]
    def onFailure: Optional[zio.aws.imagebuilder.model.OnWorkflowFailure]
    def getWorkflowArn: ZIO[Any, Nothing, WorkflowVersionArnOrBuildVersionArn] =
      ZIO.succeed(workflowArn)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getParallelGroup: ZIO[Any, AwsError, ParallelGroup] =
      AwsError.unwrapOptionField("parallelGroup", parallelGroup)
    def getOnFailure
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.OnWorkflowFailure] =
      AwsError.unwrapOptionField("onFailure", onFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration
  ) extends zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly {
    override val workflowArn: WorkflowVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .WorkflowVersionArnOrBuildVersionArn(impl.workflowArn())
    override val parameters: Optional[
      List[zio.aws.imagebuilder.model.WorkflowParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowParameter.wrap(item)
        }.toList
      )
    override val parallelGroup: Optional[ParallelGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelGroup())
      .map(value => zio.aws.imagebuilder.model.primitives.ParallelGroup(value))
    override val onFailure
        : Optional[zio.aws.imagebuilder.model.OnWorkflowFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onFailure())
        .map(value => zio.aws.imagebuilder.model.OnWorkflowFailure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration
  ): zio.aws.imagebuilder.model.WorkflowConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
