package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ClientToken,
  RoleNameOrArn,
  NonEmptyString,
  LifecyclePolicyArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLifecyclePolicyRequest(
    lifecyclePolicyArn: LifecyclePolicyArn,
    description: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      Optional.Absent,
    executionRole: RoleNameOrArn,
    resourceType: zio.aws.imagebuilder.model.LifecyclePolicyResourceType,
    policyDetails: Iterable[zio.aws.imagebuilder.model.LifecyclePolicyDetail],
    resourceSelection: zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest = {
    import UpdateLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest
      .builder()
      .lifecyclePolicyArn(
        LifecyclePolicyArn.unwrap(lifecyclePolicyArn): java.lang.String
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .executionRole(RoleNameOrArn.unwrap(executionRole): java.lang.String)
      .resourceType(resourceType.unwrap)
      .policyDetails(policyDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .resourceSelection(resourceSelection.buildAwsValue())
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest
      .wrap(buildAwsValue())
}
object UpdateLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest =
      zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest(
        lifecyclePolicyArn,
        description.map(value => value),
        status.map(value => value),
        executionRole,
        resourceType,
        policyDetails.map { item =>
          item.asEditable
        },
        resourceSelection.asEditable,
        clientToken
      )
    def lifecyclePolicyArn: LifecyclePolicyArn
    def description: Optional[NonEmptyString]
    def status: Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus]
    def executionRole: RoleNameOrArn
    def resourceType: zio.aws.imagebuilder.model.LifecyclePolicyResourceType
    def policyDetails
        : List[zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly]
    def resourceSelection
        : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly
    def clientToken: ClientToken
    def getLifecyclePolicyArn: ZIO[Any, Nothing, LifecyclePolicyArn] =
      ZIO.succeed(lifecyclePolicyArn)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getExecutionRole: ZIO[Any, Nothing, RoleNameOrArn] =
      ZIO.succeed(executionRole)
    def getResourceType: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.LifecyclePolicyResourceType
    ] = ZIO.succeed(resourceType)
    def getPolicyDetails: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly
    ]] = ZIO.succeed(policyDetails)
    def getResourceSelection: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly
    ] = ZIO.succeed(resourceSelection)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest
  ) extends zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest.ReadOnly {
    override val lifecyclePolicyArn: LifecyclePolicyArn =
      zio.aws.imagebuilder.model.primitives
        .LifecyclePolicyArn(impl.lifecyclePolicyArn())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val status
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.LifecyclePolicyStatus.wrap(value)
        )
    override val executionRole: RoleNameOrArn =
      zio.aws.imagebuilder.model.primitives.RoleNameOrArn(impl.executionRole())
    override val resourceType
        : zio.aws.imagebuilder.model.LifecyclePolicyResourceType =
      zio.aws.imagebuilder.model.LifecyclePolicyResourceType
        .wrap(impl.resourceType())
    override val policyDetails
        : List[zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly] = impl
      .policyDetails()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.LifecyclePolicyDetail.wrap(item)
      }
      .toList
    override val resourceSelection
        : zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly =
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection
        .wrap(impl.resourceSelection())
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest
  ): zio.aws.imagebuilder.model.UpdateLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
