package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InfrastructureConfigurationArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateInfrastructureConfigurationResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    infrastructureConfigurationArn: Optional[InfrastructureConfigurationArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse = {
    import UpdateInfrastructureConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        infrastructureConfigurationArn.map(value =>
          InfrastructureConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.infrastructureConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateInfrastructureConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse =
      zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        infrastructureConfigurationArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def clientToken: Optional[ClientToken]
    def infrastructureConfigurationArn: Optional[InfrastructureConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInfrastructureConfigurationArn
        : ZIO[Any, AwsError, InfrastructureConfigurationArn] =
      AwsError.unwrapOptionField(
        "infrastructureConfigurationArn",
        infrastructureConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ) extends zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val infrastructureConfigurationArn
        : Optional[InfrastructureConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.infrastructureConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .InfrastructureConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ): zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
