package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait TenancyType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.TenancyType
}
object TenancyType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.TenancyType
  ): zio.aws.imagebuilder.model.TenancyType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.TenancyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.TenancyType.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.imagebuilder.model.TenancyType.DEDICATED =>
      val r = dedicated
      r
    case software.amazon.awssdk.services.imagebuilder.model.TenancyType.HOST =>
      val r = host
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.TenancyType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.TenancyType =
      software.amazon.awssdk.services.imagebuilder.model.TenancyType.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.imagebuilder.model.TenancyType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.TenancyType =
      software.amazon.awssdk.services.imagebuilder.model.TenancyType.DEFAULT
  }
  case object dedicated extends zio.aws.imagebuilder.model.TenancyType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.TenancyType =
      software.amazon.awssdk.services.imagebuilder.model.TenancyType.DEDICATED
  }
  case object host extends zio.aws.imagebuilder.model.TenancyType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.TenancyType =
      software.amazon.awssdk.services.imagebuilder.model.TenancyType.HOST
  }
}
