package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.SeverityCountNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SeverityCounts(
    all: Optional[SeverityCountNumber] = Optional.Absent,
    critical: Optional[SeverityCountNumber] = Optional.Absent,
    high: Optional[SeverityCountNumber] = Optional.Absent,
    medium: Optional[SeverityCountNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.SeverityCounts = {
    import SeverityCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.SeverityCounts
      .builder()
      .optionallyWith(
        all.map(value => SeverityCountNumber.unwrap(value): java.lang.Long)
      )(_.all)
      .optionallyWith(
        critical.map(value => SeverityCountNumber.unwrap(value): java.lang.Long)
      )(_.critical)
      .optionallyWith(
        high.map(value => SeverityCountNumber.unwrap(value): java.lang.Long)
      )(_.high)
      .optionallyWith(
        medium.map(value => SeverityCountNumber.unwrap(value): java.lang.Long)
      )(_.medium)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.SeverityCounts.ReadOnly =
    zio.aws.imagebuilder.model.SeverityCounts.wrap(buildAwsValue())
}
object SeverityCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.SeverityCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.SeverityCounts =
      zio.aws.imagebuilder.model.SeverityCounts(
        all.map(value => value),
        critical.map(value => value),
        high.map(value => value),
        medium.map(value => value)
      )
    def all: Optional[SeverityCountNumber]
    def critical: Optional[SeverityCountNumber]
    def high: Optional[SeverityCountNumber]
    def medium: Optional[SeverityCountNumber]
    def getAll: ZIO[Any, AwsError, SeverityCountNumber] =
      AwsError.unwrapOptionField("all", all)
    def getCritical: ZIO[Any, AwsError, SeverityCountNumber] =
      AwsError.unwrapOptionField("critical", critical)
    def getHigh: ZIO[Any, AwsError, SeverityCountNumber] =
      AwsError.unwrapOptionField("high", high)
    def getMedium: ZIO[Any, AwsError, SeverityCountNumber] =
      AwsError.unwrapOptionField("medium", medium)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.SeverityCounts
  ) extends zio.aws.imagebuilder.model.SeverityCounts.ReadOnly {
    override val all: Optional[SeverityCountNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.all())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.SeverityCountNumber(value)
      )
    override val critical: Optional[SeverityCountNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.critical())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.SeverityCountNumber(value)
      )
    override val high: Optional[SeverityCountNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.high())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.SeverityCountNumber(value)
      )
    override val medium: Optional[SeverityCountNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.medium())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.SeverityCountNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.SeverityCounts
  ): zio.aws.imagebuilder.model.SeverityCounts.ReadOnly = new Wrapper(impl)
}
