package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ClientToken,
  NonEmptyString,
  ImageBuildVersionArn,
  WorkflowStepExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendWorkflowStepActionRequest(
    stepExecutionId: WorkflowStepExecutionId,
    imageBuildVersionArn: ImageBuildVersionArn,
    action: zio.aws.imagebuilder.model.WorkflowStepActionType,
    reason: Optional[NonEmptyString] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest = {
    import SendWorkflowStepActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest
      .builder()
      .stepExecutionId(
        WorkflowStepExecutionId.unwrap(stepExecutionId): java.lang.String
      )
      .imageBuildVersionArn(
        ImageBuildVersionArn.unwrap(imageBuildVersionArn): java.lang.String
      )
      .action(action.unwrap)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.SendWorkflowStepActionRequest.ReadOnly =
    zio.aws.imagebuilder.model.SendWorkflowStepActionRequest
      .wrap(buildAwsValue())
}
object SendWorkflowStepActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.SendWorkflowStepActionRequest =
      zio.aws.imagebuilder.model.SendWorkflowStepActionRequest(
        stepExecutionId,
        imageBuildVersionArn,
        action,
        reason.map(value => value),
        clientToken
      )
    def stepExecutionId: WorkflowStepExecutionId
    def imageBuildVersionArn: ImageBuildVersionArn
    def action: zio.aws.imagebuilder.model.WorkflowStepActionType
    def reason: Optional[NonEmptyString]
    def clientToken: ClientToken
    def getStepExecutionId: ZIO[Any, Nothing, WorkflowStepExecutionId] =
      ZIO.succeed(stepExecutionId)
    def getImageBuildVersionArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageBuildVersionArn)
    def getAction
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.WorkflowStepActionType] =
      ZIO.succeed(action)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest
  ) extends zio.aws.imagebuilder.model.SendWorkflowStepActionRequest.ReadOnly {
    override val stepExecutionId: WorkflowStepExecutionId =
      zio.aws.imagebuilder.model.primitives
        .WorkflowStepExecutionId(impl.stepExecutionId())
    override val imageBuildVersionArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageBuildVersionArn())
    override val action: zio.aws.imagebuilder.model.WorkflowStepActionType =
      zio.aws.imagebuilder.model.WorkflowStepActionType.wrap(impl.action())
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest
  ): zio.aws.imagebuilder.model.SendWorkflowStepActionRequest.ReadOnly =
    new Wrapper(impl)
}
