package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ResourceStatus
}
object ResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ResourceStatus
  ): zio.aws.imagebuilder.model.ResourceStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DEPRECATED =>
      val r = DEPRECATED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ResourceStatus =
      software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.imagebuilder.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ResourceStatus =
      software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.AVAILABLE
  }
  case object DELETED extends zio.aws.imagebuilder.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ResourceStatus =
      software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DELETED
  }
  case object DEPRECATED extends zio.aws.imagebuilder.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ResourceStatus =
      software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DEPRECATED
  }
  case object DISABLED extends zio.aws.imagebuilder.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ResourceStatus =
      software.amazon.awssdk.services.imagebuilder.model.ResourceStatus.DISABLED
  }
}
