package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuildVersionArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutImagePolicyResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageArn: Optional[ImageBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse = {
    import PutImagePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutImagePolicyResponse.wrap(buildAwsValue())
}
object PutImagePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutImagePolicyResponse =
      zio.aws.imagebuilder.model.PutImagePolicyResponse(
        requestId.map(value => value),
        imageArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageArn: Optional[ImageBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse
  ) extends zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse
  ): zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
