package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  ImageBuildVersionArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutImagePolicyRequest(
    imageArn: ImageBuildVersionArn,
    policy: ResourcePolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest = {
    import PutImagePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest
      .builder()
      .imageArn(ImageBuildVersionArn.unwrap(imageArn): java.lang.String)
      .policy(ResourcePolicyDocument.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.PutImagePolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.PutImagePolicyRequest.wrap(buildAwsValue())
}
object PutImagePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutImagePolicyRequest =
      zio.aws.imagebuilder.model.PutImagePolicyRequest(imageArn, policy)
    def imageArn: ImageBuildVersionArn
    def policy: ResourcePolicyDocument
    def getImageArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageArn)
    def getPolicy: ZIO[Any, Nothing, ResourcePolicyDocument] =
      ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest
  ) extends zio.aws.imagebuilder.model.PutImagePolicyRequest.ReadOnly {
    override val imageArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageArn())
    override val policy: ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives
        .ResourcePolicyDocument(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest
  ): zio.aws.imagebuilder.model.PutImagePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
