package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ContainerRecipeArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutContainerRecipePolicyResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    containerRecipeArn: Optional[ContainerRecipeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse = {
    import PutContainerRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse
      .wrap(buildAwsValue())
}
object PutContainerRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse =
      zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse(
        requestId.map(value => value),
        containerRecipeArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def containerRecipeArn: Optional[ContainerRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipeArn: Optional[ContainerRecipeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerRecipeArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ): zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
