package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ProductCodeType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ProductCodeType
}
object ProductCodeType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ProductCodeType
  ): zio.aws.imagebuilder.model.ProductCodeType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ProductCodeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ProductCodeType.MARKETPLACE =>
      val r = marketplace
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ProductCodeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ProductCodeType =
      software.amazon.awssdk.services.imagebuilder.model.ProductCodeType.UNKNOWN_TO_SDK_VERSION
  }
  case object marketplace extends zio.aws.imagebuilder.model.ProductCodeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ProductCodeType =
      software.amazon.awssdk.services.imagebuilder.model.ProductCodeType.MARKETPLACE
  }
}
