package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Placement(
    availabilityZone: Optional[NonEmptyString] = Optional.Absent,
    tenancy: Optional[zio.aws.imagebuilder.model.TenancyType] = Optional.Absent,
    hostId: Optional[NonEmptyString] = Optional.Absent,
    hostResourceGroupArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Placement = {
    import Placement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Placement
      .builder()
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        hostId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostId)
      .optionallyWith(
        hostResourceGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Placement.ReadOnly =
    zio.aws.imagebuilder.model.Placement.wrap(buildAwsValue())
}
object Placement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Placement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Placement =
      zio.aws.imagebuilder.model.Placement(
        availabilityZone.map(value => value),
        tenancy.map(value => value),
        hostId.map(value => value),
        hostResourceGroupArn.map(value => value)
      )
    def availabilityZone: Optional[NonEmptyString]
    def tenancy: Optional[zio.aws.imagebuilder.model.TenancyType]
    def hostId: Optional[NonEmptyString]
    def hostResourceGroupArn: Optional[NonEmptyString]
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTenancy: ZIO[Any, AwsError, zio.aws.imagebuilder.model.TenancyType] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getHostId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getHostResourceGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Placement
  ) extends zio.aws.imagebuilder.model.Placement.ReadOnly {
    override val availabilityZone: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val tenancy: Optional[zio.aws.imagebuilder.model.TenancyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.imagebuilder.model.TenancyType.wrap(value))
    override val hostId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.hostId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val hostResourceGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostResourceGroupArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Placement
  ): zio.aws.imagebuilder.model.Placement.ReadOnly = new Wrapper(impl)
}
