package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  DateTimeTimestamp,
  NonEmptyString,
  VulnerabilityId
}
import scala.jdk.CollectionConverters.*
final case class PackageVulnerabilityDetails(
    vulnerabilityId: VulnerabilityId,
    vulnerablePackages: Optional[
      Iterable[zio.aws.imagebuilder.model.VulnerablePackage]
    ] = Optional.Absent,
    source: Optional[NonEmptyString] = Optional.Absent,
    cvss: Optional[Iterable[zio.aws.imagebuilder.model.CvssScore]] =
      Optional.Absent,
    relatedVulnerabilities: Optional[Iterable[VulnerabilityId]] =
      Optional.Absent,
    sourceUrl: Optional[NonEmptyString] = Optional.Absent,
    vendorSeverity: Optional[NonEmptyString] = Optional.Absent,
    vendorCreatedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    vendorUpdatedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    referenceUrls: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails = {
    import PackageVulnerabilityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails
      .builder()
      .vulnerabilityId(
        VulnerabilityId.unwrap(vulnerabilityId): java.lang.String
      )
      .optionallyWith(
        vulnerablePackages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerablePackages)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        cvss.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cvss)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            VulnerabilityId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(
        sourceUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceUrl)
      .optionallyWith(
        vendorSeverity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vendorCreatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.vendorCreatedAt)
      .optionallyWith(
        vendorUpdatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.vendorUpdatedAt)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly =
    zio.aws.imagebuilder.model.PackageVulnerabilityDetails.wrap(buildAwsValue())
}
object PackageVulnerabilityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PackageVulnerabilityDetails =
      zio.aws.imagebuilder.model.PackageVulnerabilityDetails(
        vulnerabilityId,
        vulnerablePackages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source.map(value => value),
        cvss.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedVulnerabilities.map(value => value),
        sourceUrl.map(value => value),
        vendorSeverity.map(value => value),
        vendorCreatedAt.map(value => value),
        vendorUpdatedAt.map(value => value),
        referenceUrls.map(value => value)
      )
    def vulnerabilityId: VulnerabilityId
    def vulnerablePackages
        : Optional[List[zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly]]
    def source: Optional[NonEmptyString]
    def cvss: Optional[List[zio.aws.imagebuilder.model.CvssScore.ReadOnly]]
    def relatedVulnerabilities: Optional[List[VulnerabilityId]]
    def sourceUrl: Optional[NonEmptyString]
    def vendorSeverity: Optional[NonEmptyString]
    def vendorCreatedAt: Optional[DateTimeTimestamp]
    def vendorUpdatedAt: Optional[DateTimeTimestamp]
    def referenceUrls: Optional[List[NonEmptyString]]
    def getVulnerabilityId: ZIO[Any, Nothing, VulnerabilityId] =
      ZIO.succeed(vulnerabilityId)
    def getVulnerablePackages: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerablePackages", vulnerablePackages)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
    def getCvss: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.CvssScore.ReadOnly
    ]] = AwsError.unwrapOptionField("cvss", cvss)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[VulnerabilityId]] =
      AwsError.unwrapOptionField(
        "relatedVulnerabilities",
        relatedVulnerabilities
      )
    def getSourceUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getVendorSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVendorCreatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("vendorCreatedAt", vendorCreatedAt)
    def getVendorUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("vendorUpdatedAt", vendorUpdatedAt)
    def getReferenceUrls: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails
  ) extends zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly {
    override val vulnerabilityId: VulnerabilityId =
      zio.aws.imagebuilder.model.primitives
        .VulnerabilityId(impl.vulnerabilityId())
    override val vulnerablePackages: Optional[
      List[zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vulnerablePackages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.VulnerablePackage.wrap(item)
        }.toList
      )
    override val source: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val cvss
        : Optional[List[zio.aws.imagebuilder.model.CvssScore.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cvss())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.CvssScore.wrap(item)
          }.toList
        )
    override val relatedVulnerabilities: Optional[List[VulnerabilityId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedVulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.VulnerabilityId(item)
          }.toList
        )
    override val sourceUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceUrl())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val vendorSeverity: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorSeverity())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val vendorCreatedAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorCreatedAt())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val vendorUpdatedAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorUpdatedAt())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val referenceUrls: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails
  ): zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly =
    new Wrapper(impl)
}
