package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait OnWorkflowFailure {
  def unwrap
      : software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure
}
object OnWorkflowFailure {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure
  ): zio.aws.imagebuilder.model.OnWorkflowFailure = value match {
    case software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.CONTINUE =>
      val r = CONTINUE
      r
    case software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.ABORT =>
      val r = ABORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.OnWorkflowFailure {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure =
      software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE extends zio.aws.imagebuilder.model.OnWorkflowFailure {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure =
      software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.CONTINUE
  }
  case object ABORT extends zio.aws.imagebuilder.model.OnWorkflowFailure {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure =
      software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure.ABORT
  }
}
