package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait MarketplaceResourceType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType
}
object MarketplaceResourceType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType
  ): zio.aws.imagebuilder.model.MarketplaceResourceType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.COMPONENT_DATA =>
      val r = COMPONENT_DATA
      r
    case software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.COMPONENT_ARTIFACT =>
      val r = COMPONENT_ARTIFACT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.MarketplaceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType =
      software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPONENT_DATA
      extends zio.aws.imagebuilder.model.MarketplaceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType =
      software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.COMPONENT_DATA
  }
  case object COMPONENT_ARTIFACT
      extends zio.aws.imagebuilder.model.MarketplaceResourceType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType =
      software.amazon.awssdk.services.imagebuilder.model.MarketplaceResourceType.COMPONENT_ARTIFACT
  }
}
