package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowBuildVersionsResponse(
    workflowSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse = {
    import ListWorkflowBuildVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse
      .builder()
      .optionallyWith(
        workflowSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowBuildVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse =
      zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse(
        workflowSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workflowSummaryList
        : Optional[List[zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getWorkflowSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowSummaryList", workflowSummaryList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse
  ) extends zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly {
    override val workflowSummaryList
        : Optional[List[zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.WorkflowSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse
  ): zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
