package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWaitingWorkflowStepsRequest(
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest = {
    import ListWaitingWorkflowStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest
      .wrap(buildAwsValue())
}
object ListWaitingWorkflowStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest =
      zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest
  ) extends zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest.ReadOnly {
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest
  ): zio.aws.imagebuilder.model.ListWaitingWorkflowStepsRequest.ReadOnly =
    new Wrapper(impl)
}
