package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLifecyclePoliciesResponse(
    lifecyclePolicySummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.LifecyclePolicySummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse = {
    import ListLifecyclePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse
      .builder()
      .optionallyWith(
        lifecyclePolicySummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicySummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse
      .wrap(buildAwsValue())
}
object ListLifecyclePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse =
      zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse(
        lifecyclePolicySummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lifecyclePolicySummaryList: Optional[
      List[zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getLifecyclePolicySummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lifecyclePolicySummaryList",
      lifecyclePolicySummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse
  ) extends zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly {
    override val lifecyclePolicySummaryList: Optional[
      List[zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicySummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecyclePolicySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse
  ): zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
