package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListImageRecipesResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageRecipeSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.ImageRecipeSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse = {
    import ListImageRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageRecipeSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImageRecipesResponse.wrap(buildAwsValue())
}
object ListImageRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageRecipesResponse =
      zio.aws.imagebuilder.model.ListImageRecipesResponse(
        requestId.map(value => value),
        imageRecipeSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageRecipeSummaryList
        : Optional[List[zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "imageRecipeSummaryList",
      imageRecipeSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ) extends zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeSummaryList: Optional[
      List[zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageRecipeSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ImageRecipeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ): zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly = new Wrapper(
    impl
  )
}
