package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    componentVersionList: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentVersion]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse = {
    import ListComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        componentVersionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentVersionList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListComponentsResponse.wrap(buildAwsValue())
}
object ListComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListComponentsResponse =
      zio.aws.imagebuilder.model.ListComponentsResponse(
        requestId.map(value => value),
        componentVersionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def componentVersionList
        : Optional[List[zio.aws.imagebuilder.model.ComponentVersion.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponentVersionList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
    ]] =
      AwsError.unwrapOptionField("componentVersionList", componentVersionList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse
  ) extends zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val componentVersionList
        : Optional[List[zio.aws.imagebuilder.model.ComponentVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentVersionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ComponentVersion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse
  ): zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
